document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('unsubscribe-form');
    const emailField = document.getElementById('email');
    const emailError = document.getElementById('email-error');
    const reasonField = document.getElementById('reason');
    const otherReasonContainer = document.getElementById('other-reason-container');
    const otherReasonField = document.getElementById('other-reason');

    const confirmationMessage = document.getElementById('confirmation-message');
    
    // Show "Other" reason text field when "Other" is selected
    reasonField.addEventListener('change', function() {
        if (this.value === 'other') {
            otherReasonContainer.style.display = 'block';
        } else {
            otherReasonContainer.style.display = 'none';
            otherReasonField.value = '';
        }
    });

    // Basic email validation
    function isValidEmail(email) {
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailPattern.test(email);
    }
    
    // Validate email on input
    emailField.addEventListener('input', function() {
        if (!isValidEmail(this.value) && this.value.length > 0) {
            emailError.textContent = 'Please enter a valid email address';
            emailField.classList.add('error');
        } else {
            emailError.textContent = '';
            emailField.classList.remove('error');
        }
    });



    // Handle form submission
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Validate email
        if (!isValidEmail(emailField.value)) {
            emailError.textContent = 'Please enter a valid email address';
            emailField.focus();
            return;
        }
        
        // Collect form data
        const formData = new FormData(form);
        
        // Send data to server
        fetch('process_unsubscribe.php', {
            method: 'POST',
            body: formData
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            // Show confirmation message
            form.style.display = 'none';
            confirmationMessage.style.display = 'block';
            console.log('Success:', data);
        })
        .catch(error => {
            console.error('Error:', error);
            alert('There was a problem processing your request. Please try again later.');
        });
    });
});